Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient

Public Class Contact
    Const conString As String = "Data Source=.\SQLEXPRESS;AttachDbFilename=|DataDirectory|\DiaryDB.mdf;Integrated Security=True;User Instance=True"
    Private mContactId As Long = -1
    Private mDiaryId As Integer = -1
    Private mFirstName As String
    Private mLastName As String
    Private mTelephone As String
    Private mMobilePhone As String
    Private mEmail As String
    Private mAddressLine1 As String
    Private mCity As String
    Private mState As String
    Private mPostalCode As String
#Region "Waciwoci"
  Public ReadOnly Property ContactId() As Long
    Get
      ContactId = mContactId
    End Get
  End Property
  Public Property PostalCode() As String
    Get
      PostalCode = mPostalCode
    End Get
    Set(ByVal value As String)
      mPostalCode = value
    End Set
  End Property
  Public Property State() As String
    Get
      State = mState
    End Get
    Set(ByVal value As String)
      mState = value
    End Set
  End Property
  Public Property City() As String
    Get
      City = mCity
    End Get
    Set(ByVal value As String)
      mCity = value
    End Set
  End Property
  Public Property AddressLine1() As String
    Get
      AddressLine1 = mAddressLine1
    End Get
    Set(ByVal value As String)
      mAddressLine1 = value
    End Set
  End Property
  Public Property Email() As String
    Get
      Email = mEmail
    End Get
    Set(ByVal value As String)
      mEmail = value
    End Set
  End Property
  Public Property MobilePhone() As String
    Get
      MobilePhone = mMobilePhone
    End Get
    Set(ByVal value As String)
      mMobilePhone = value
    End Set
  End Property
  Public Property Telephone() As String
    Get
      Telephone = mTelephone
    End Get
    Set(ByVal value As String)
      mTelephone = value
    End Set
  End Property

  Public Property LastName() As String
    Get
      LastName = mLastName
    End Get
    Set(ByVal value As String)
      mLastName = value
    End Set
  End Property

  Public Property FirstName() As String
    Get
      FirstName = mFirstName
    End Get
    Set(ByVal value As String)
      mFirstName = value
    End Set
  End Property
#End Region

#Region "Konstruktory"
  Public Sub New(ByVal DiaryId As Integer)
    mDiaryId = DiaryId
    Initialise()
  End Sub

  Public Sub New(ByVal ContactId As Long)
    mContactId = ContactId

    If mContactId <> -1 Then
      Try
        Dim diaryDBConn As New SqlConnection(conString)

        Dim sqlString As String = "GetContactById"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@ContactId", mContactId)

        diaryDBConn.Open()
        Dim contactSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        sqlCmd = Nothing
        If contactSQLDR.Read() Then
          mFirstName = contactSQLDR("FirstName").ToString
          mLastName = contactSQLDR("LastName").ToString
          mTelephone = contactSQLDR("Telephone").ToString
          mMobilePhone = contactSQLDR("MobilePhone").ToString
          mEmail = contactSQLDR("Email").ToString
          mAddressLine1 = contactSQLDR("AddressLine1").ToString
          mCity = contactSQLDR("City").ToString
          mState = contactSQLDR("State").ToString
          mPostalCode = contactSQLDR("PostalCode").ToString
          mDiaryId = CInt(contactSQLDR("DiaryId"))
        Else
          mContactId = -1
        End If

        contactSQLDR.Close()
        contactSQLDR = Nothing
        diaryDBConn.Close()
        diaryDBConn = Nothing

      Catch ex As Exception
        mContactId = -1
      End Try

    End If

  End Sub

#End Region

#Region "Skadniki prywatne"

  Private Sub Initialise()
    mContactId = -1
    mFirstName = ""
    mLastName = ""
    mTelephone = ""
    mMobilePhone = ""
    mEmail = ""
    mAddressLine1 = ""
    mCity = ""
    mState = ""
    mPostalCode = ""
  End Sub

  Private Sub InsertNewContact()

    If mDiaryId <> -1 Then
      Dim diaryDBConn As New SqlConnection(conString)
      Dim sqlString As String = "InsertContact"
      Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
      sqlCmd.CommandType = CommandType.StoredProcedure

      sqlCmd.Parameters.AddWithValue("@DiaryId", mDiaryId)
      sqlCmd.Parameters.AddWithValue("@FirstName", mFirstName)
      sqlCmd.Parameters.AddWithValue("@LastName", mLastName)
      sqlCmd.Parameters.AddWithValue("@Telephone", mTelephone)
      sqlCmd.Parameters.AddWithValue("@MobilePhone", mMobilePhone)
      sqlCmd.Parameters.AddWithValue("@Email", mEmail)
      sqlCmd.Parameters.AddWithValue("@AddressLine1", mAddressLine1)
      sqlCmd.Parameters.AddWithValue("@City", mCity)
      sqlCmd.Parameters.AddWithValue("@State", mState)
      sqlCmd.Parameters.AddWithValue("@PostalCode", mPostalCode)
      sqlCmd.Parameters.Add("@NewContactId", SqlDbType.BigInt)
      sqlCmd.Parameters("@NewContactId").Direction = ParameterDirection.ReturnValue

      diaryDBConn.Open()
      sqlCmd.ExecuteNonQuery()
      mContactId = CLng(sqlCmd.Parameters("@NewContactId").Value())

      diaryDBConn.Close()
      sqlCmd = Nothing
      diaryDBConn = Nothing
    End If
  End Sub

  Private Sub UpdateContact()
    If mContactId <> -1 Then
      Dim diaryDBConn As New SqlConnection(conString)
      Dim sqlString As String = "UpdateContact"
      Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
      sqlCmd.CommandType = CommandType.StoredProcedure

      sqlCmd.Parameters.AddWithValue("@ContactId", mContactId)
      sqlCmd.Parameters.AddWithValue("@FirstName", mFirstName)
      sqlCmd.Parameters.AddWithValue("@LastName", mLastName)
      sqlCmd.Parameters.AddWithValue("@Telephone", mTelephone)
      sqlCmd.Parameters.AddWithValue("@MobilePhone", mMobilePhone)
      sqlCmd.Parameters.AddWithValue("@Email", mEmail)
      sqlCmd.Parameters.AddWithValue("@AddressLine1", mAddressLine1)
      sqlCmd.Parameters.AddWithValue("@City", mCity)
      sqlCmd.Parameters.AddWithValue("@State", mState)
      sqlCmd.Parameters.AddWithValue("@PostalCode", mPostalCode)

      diaryDBConn.Open()
      sqlCmd.ExecuteNonQuery()
      diaryDBConn.Close()
      sqlCmd = Nothing
      diaryDBConn = Nothing
    End If

  End Sub

#End Region

#Region "Wspuytkowane funkcje publiczne"
    Public Shared Function GetContactsByFirstLetterAsCollection(ByVal DiaryId As Integer, Optional ByVal FirstLetterOfSurname As Char = "*") As ContactCollection
        Dim Contacts As New ContactCollection()
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetContactsBySurnameFirstLetter"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@DiaryId", DiaryId)
        sqlCmd.Parameters.AddWithValue("@FirstLetterOfSurname", FirstLetterOfSurname)

        diaryDBConn.Open()
        Dim contactSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)

        sqlCmd = Nothing

        Do While contactSQLDR.Read()
            Contacts.Add(CLng(contactSQLDR("ContactId")))
        Loop

        contactSQLDR.Close()
        contactSQLDR = Nothing
        diaryDBConn.Close()
        diaryDBConn = Nothing
        Return Contacts
    End Function

    Public Shared Function GetContactsByFirstLetter(ByVal DiaryId As Integer, Optional ByVal FirstLetterOfSurname As Char = "*") As SqlDataReader
        Dim Contacts As New ContactCollection()
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetContactsBySurnameFirstLetter"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@DiaryId", DiaryId)
        sqlCmd.Parameters.AddWithValue("@FirstLetterOfSurname", FirstLetterOfSurname)

        diaryDBConn.Open()
        Dim contactSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        sqlCmd = Nothing
        Return contactSQLDR
    End Function
#End Region

#Region "Funkcje publiczne"
  Public Sub DeleteContact()
    If mContactId <> -1 Then
      DeleteContact(mContactId)
      Initialise()

    End If
  End Sub

  Public Shared Sub DeleteContact(ByVal ContactId As Long)
    Dim diaryDBConn As New SqlConnection(conString)
    Dim sqlString As String = "DeleteContact"
    Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
    sqlCmd.CommandType = CommandType.StoredProcedure

    sqlCmd.Parameters.AddWithValue("@ContactId", ContactId)
    diaryDBConn.Open()
    sqlCmd.ExecuteNonQuery()
    diaryDBConn.Close()
    sqlCmd = Nothing
    diaryDBConn = Nothing
  End Sub

  Public Sub SaveContact()
    If mContactId = -1 Then
      InsertNewContact()
    Else
      UpdateContact()
    End If
  End Sub
#End Region
End Class
